<?php

/**
 * Copyright since 2025 iqit-commerce.com
 *
 * NOTICE OF LICENSE
 *
 * This source file is subject to the Envato Regular License,
 * which is bundled with this package in the file LICENSE.md.
 * It is also available through the world-wide-web at the following URL:
 * https://themeforest.net/licenses/terms/regular
 * If you did not receive a copy of the license and are unable to
 * obtain it through the world-wide-web, please send an email
 * to support@iqit-commerce.com so we can send you a copy immediately.
 *
 * @author    iqit-commerce.com <support@iqit-commerce.com>
 * @copyright Since 2025 iqit-commerce.com
 * @license   Envato Regular License
 */

namespace Iqit\IqitProductVariants\Entity;

/**
 * Example object model for module custom product fields
 */
final class ProductVariant extends \ObjectModel
{
    /**
     * @var int
     */
    public $id_product;

    /**
     * @var string
     */
    public $variants = '';

    /**
     * @var string
     */
    public $date_add;

    /**
     * @var string
     */
    public $date_upd;

    /**
     * @var bool forces the id to be set before saving object (because we don't need autogenerated id for this model)
     */
    public $force_id = true;

    public static $definition = [
        'table' => 'iqitproductvariants_product_variant',
        'primary' => 'id_product',
        'fields' => [
            'id_product' => ['type' => self::TYPE_INT],
            'variants' => ['type' => self::TYPE_STRING],
            'date_add' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
            'date_upd' => ['type' => self::TYPE_DATE, 'validate' => 'isDate'],
        ],
    ];

    public static function getInstanceByProductId(
        int $idProduct,
        ?int $idLang = null,
        ?int $idShop = null,
    ): self {
        $sql = new \DbQuery();
        $sql->select(self::$definition['primary']);
        $sql->from(self::$definition['table'], 'b');
        $sql->where('b.id_product = ' . (int) $idProduct);

        $idObject = (int) \Db::getInstance()->getValue($sql);

        return new self($idObject, $idLang, $idShop);
    }
}
